USE [SUPERMERCADO]
-- =============================================
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- AUTOR: ERICK MARTINEZ
-- FECHA DE CREACION: 10/06/2015
-- DESCRIPCION: CUANTO DINERO SE OBTUVO DE GANANCIA DE EN UNA FECHA 
-- =============================================
CREATE FUNCTION [dbo].[GANANCIA_FECHA]
(
	@FECHA DATE,
	@ID_SUCURSAL INT
)
RETURNS FLOAT
AS
BEGIN

	DECLARE @DINERO_GANANCIA FLOAT = 0

	SELECT 
		@DINERO_GANANCIA =
			@DINERO_GANANCIA +
			[SUPERMERCADO].[dbo].[FACTURA_PRODUCTO].[CANTIDAD_PRODUCTO] *
			(
			[SUPERMERCADO].[dbo].[PRODUCTO].[VENTA_PRODUCTO] - 
			[SUPERMERCADO].[dbo].[PRODUCTO].[COMPRA_PRODUCTO]
			)

	FROM 
		[SUPERMERCADO].[dbo].[FACTURA_PRODUCTO]
	
	INNER JOIN 
		[SUPERMERCADO].[dbo].[PRODUCTO]
	ON 
		[SUPERMERCADO].[dbo].[FACTURA_PRODUCTO].[ID_PRODUCTO] = 
		[SUPERMERCADO].[dbo].[PRODUCTO].[ID_PRODUCTO]

	INNER JOIN 
		[SUPERMERCADO].[dbo].[FACTURA]
	ON 
		[SUPERMERCADO].[dbo].[FACTURA_PRODUCTO].[ID_FACTURA] = 
		[SUPERMERCADO].[dbo].[FACTURA].[ID_FACTURA]

	WHERE 
		@FECHA = [SUPERMERCADO].[dbo].[FACTURA].[FECHA_FACTURA] AND
		@ID_SUCURSAL = [SUPERMERCADO].[dbo].[FACTURA].[ID_SUCURSAL_FACTURA]

	


	RETURN @DINERO_GANANCIA

END

GO


